#!/bin/bash

INTERVAL=1
PREVUPBYTES=$(awk '/IpExt:/ {print $8}' /proc/net/netstat | tail -n1)
PREVDOWNBYTES=$(awk '/IpExt:/ {print $9}' /proc/net/netstat | tail -n1)

while true; do
    UPBYTES=$(awk '/IpExt:/ {print $8}' /proc/net/netstat | tail -n1)
    DOWNBYTES=$(awk '/IpExt:/ {print $9}' /proc/net/netstat | tail -n1)
    UPDIFF=$((UPBYTES - PREVUPBYTES))
    DOWNDIFF=$((DOWNBYTES - PREVDOWNBYTES))
    echo -e "{\"text\": \"$((UPDIFF / 1024)) KB⇣ $((DOWNDIFF / 1024)) KB⇡\", \"tooltip\": \"\", \"percentage\": 0}"
    PREVUPBYTES=$UPBYTES
    PREVDOWNBYTES=$DOWNBYTES
    sleep $INTERVAL
done

